﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Pity.aspx.cs" Inherits="ePaski.Pity" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        $(function () {
            $(".divZakladka").corner("top 8px");
            $(".divPityZakladka").corner("top 8px");

            $("[id$=btnOkForm]").button({ icons: { primary: 'ui-icon-check' } });
            $("[id$=btnAnulujForm]").button({ icons: { primary: 'ui-icon-cancel' } });

            $('#divOswiadczeniaZakladka').bind('click', function () {
                location = $('#aOswiadczenia').attr("href");
                return false;
            });

            $('#divPaskiZakladka').bind('click', function () {
                location = $('#aPaski').attr("href");
                return false;
            });

            $('[id$=divDaneDoPitZakladka]').bind('click', function () {
                location = $('#aDaneDoPit').attr("href");
                return false;
            });

            $("#dialog-form").dialog({
                autoOpen: false,
                height: 100,
                width: 270,
                modal: true,
                position: "center",
                resizable: false
            });

        });


        function OtworzOkienkoPotwierdzenia(id) {
            $("[id$=btnOkForm]").show();
            $("[id$=tbIdForm]").val(id);
            $("#dialog-form").parent().appendTo(jQuery("form:first"));
            $("#dialog-form").dialog("open");
        }

    </script>
    <style type="text/css">
        .divZakladka, .divPityZakladka {
            z-index: 3;
            position: relative;
            float: left;
            padding-top: 1px;
            width: 100px;
            height: 17px;
            border-left-style: solid;
            border-right-style: solid;
            border-top-style: solid;
            border-width: 1px;
            border-color: white;
            text-align: center;
        }

        #divOswiadczeniaZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        .divPityZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        #divDaneDoPitZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        .divZakladka a, .divPityZakladka a {
            text-decoration: none;
            color: black;
        }
    </style>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cphZakladki" runat="server">
    <div id="divPaskiZakladka" class="divZakladka">
        <a id="aPaski" href="Paski.aspx">Paski</a>
    </div>
    <div id="divOswiadczeniaZakladka" class="divZakladka">
        <a id="aOswiadczenia" href="Oswiadczenia.aspx">Oświadczenia</a>
    </div>
    <div id="divPityZakladka" class="divPityZakladka" style="background-color: white;">
        Deklaracje PIT
    </div>
    <div id="divDaneDoPitZakladka" class="divPityZakladka" runat="server">
        <a id="aDaneDoPit" href="DaneDoPit.aspx">Dane do PIT</a>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div>
        <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label>
    </div>
    <div class="divPrzerwa20">
        &nbsp;
    </div>
    <div id="divFiltry">
        <span>Rok </span>
        <asp:DropDownList ID="ddlRokOd" runat="server">
        </asp:DropDownList>
        <asp:Button ID="btnOdswiez" runat="server" OnClick="btnOdswiez_Click" Text="Odśwież" />
    </div>
    <div id="divListaPaskow">
        <div class="divPrzerwa20">
            &nbsp;
        </div>
        <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
        <asp:GridView ID="gvPity" runat="server" AllowSorting="True" AutoGenerateColumns="False"
            DataKeyNames="IdDeklaracji,IdPracownika,Rok,Wersja"
            DataSourceID="odsPity" OnRowDataBound="gvPity_RowDataBound"
            OnDataBound="gvPity_DataBound" OnRowCommand="gvPity_RowCommand">
            <AlternatingRowStyle CssClass="TableItemAlt" />
            <Columns>
                <asp:BoundField DataField="Rok" HeaderText="Rok" SortExpression="Rok" ItemStyle-Width="70px">
                    <ItemStyle Width="70px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="NazwaSlownik" HeaderText="Nazwa" SortExpression="NazwaSlownik" ItemStyle-Width="200px">
                    <ItemStyle Width="200px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="Wersja" HeaderText="Wersja" SortExpression="Wersja" ItemStyle-Width="70px">
                    <ItemStyle Width="70px"></ItemStyle>
                </asp:BoundField>
                <asp:TemplateField HeaderText="Korekta" ItemStyle-Width="70px">
                    <ItemTemplate>
                        <asp:CheckBox ID="cbKorekta" runat="server"
                            Checked='<%# (Eval("Korekta").ToString() == "T" ? true : false)  %>' Enabled="false" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" />
                </asp:TemplateField>
                <asp:TemplateField>
                    <ItemTemplate>
                        <asp:Button ID="btnWyslij" runat="server" CommandName="WYSLIJ"
                            Text="Pobierz" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" />
                </asp:TemplateField>
                <asp:BoundField DataField="DataPobrania" HeaderText="Data pobrania" SortExpression="DataPobrania" ItemStyle-Width="110px">
                    <ItemStyle Width="110px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="Pobierajacy" HeaderText="Pobierąjacy" SortExpression="Pobierajacy" ItemStyle-Width="70px">
                    <ItemStyle Width="70px"></ItemStyle>
                </asp:BoundField>
                <asp:TemplateField HeaderText="Potwierdzenie" SortExpression="DataPotwierdzeniaPobrania">
                    <ItemTemplate>
                        <asp:Label ID="lblPotwierdzenie" runat="server" Text='<%# (Eval("DataPotwierdzeniaPobrania").ToString())  %>'></asp:Label>
                        <asp:Button ID="btnPotwierdz" runat="server" CommandName="POTWIERDZ" Text="Potwierdź pobranie" Visible='<%# (Eval("DataPotwierdzeniaPobrania").ToString() == "" && Eval("DataPobrania").ToString() != "" )  %>' />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="110px" />
                </asp:TemplateField>
                <asp:BoundField DataField="PotwierdzajacyPobranie" HeaderText="Potwierdzający" SortExpression="PotwierdzajacyPobranie" ItemStyle-Width="70px">
                    <ItemStyle Width="70px"></ItemStyle>
                </asp:BoundField>
            </Columns>
            <HeaderStyle CssClass="TableHeader" />
            <RowStyle CssClass="TableItem" />
            <SelectedRowStyle CssClass="TableItemSelected" />
        </asp:GridView>
        <asp:ObjectDataSource ID="odsPity" runat="server" SelectMethod="PobierzWs" TypeName="iKPService.Pity"
            SortParameterName="sort" OnSelected="odsPity_Selected">
            <SelectParameters>
                <asp:ControlParameter ControlID="ddlRokOd" Name="rok" PropertyName="SelectedValue"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="divPrzerwa20">
            &nbsp;
        </div>
    </div>
    <div>
        <asp:Label ID="lblKomunikat" runat="server" EnableViewState="False"></asp:Label>
    </div>
    <div class="divPrzerwa20">
        &nbsp;
    </div>
    <div class="divPrzerwa20">
        &nbsp;
    </div>
    <!-- Okienko dialogu ok -->
    <div id="dialog-form" title="Potwierdzenie" style="display: none;">
        <div style="width: 100%; margin-bottom: 10px;">
            <span>Potwierdzam pobranie deklaracji PIT</span>
        </div>
        <div>
            <div style="float: right;">
                <asp:LinkButton ID="btnOkForm" runat="server" OnClick="btnOkForm_Click" Style="display: none;">Tak</asp:LinkButton>
                <asp:LinkButton ID="btnAnulujForm" runat="server" OnClick="btnAnulujForm_Click">Nie</asp:LinkButton>
                <asp:TextBox ID="tbIdForm" runat="server" Style="display: none;"></asp:TextBox>
            </div>
        </div>
    </div>
    <%--    <hr style="width:100%; height:1px;" />
    <span style="font-size:7pt">Wszelki pytania i wątpliwości dot. zasad naliczania płac można kierować do Zakładu Personalnego.</span>--%>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
</asp:Content>
